Rem LabelGraphicMenu.vbs
Rem An InDesign CS4 VBScript
Rem 
Rem Shows how to add an interactive menu element to the Layout context menu
Rem (the context menu that appears when you have an object selected).
Rem
main
Function main()
	Set myInDesign = CreateObject("InDesign.Application.CS4")
	Rem Set the user interaction level to allow the display of dialog boxes and alerts.
	myInDesign.ScriptPreferences.UserInteractionLevel = idUserInteractionLevels.idInteractWithAll	
	myString = "This script installs the Label Graphic menu item on the" & vbCr
	myString = myString & "context menu that appears when you select one or more graphics." & vbCr & vbCr
	myString = myString & "Click the OK button to add the menu item."
	myResult = MsgBox(myString, vbOKCancel, "Install Label Graphic menu item?")
	If myResult = vbOK Then
		myEventHandler = myFindFile(myInDesign, "\LabelGraphicSupport\LabelGraphicBeforeDisplay.vbs")
		If myEventHandler <> "" Then
			Rem The locale-independent name (aka "key string") for the 
			Rem Layout context menu is "$ID/RtMouseLayout".
			Set myLayoutContextMenu = myInDesign.Menus.Item("$ID/RtMouseLayout")
			Rem Create the event handler for the "beforeDisplay" event of the Layout context menu.
			Set myBeforeDisplayListener = myLayoutContextMenu.addEventListener("beforeDisplay", myEventHandler, false)
		Else
			MsgBox "Could not locate event handler VBScript file. Please reinstall the InDesign example script."
		End If
	End If
End function
Function myFindFile(myInDesign, myRelativePath)
	myFilePath = myInDesign.ActiveScript
	Set myFileSystemObject = CreateObject("Scripting.FileSystemObject")
	myFolderPath = myFileSystemObject.GetFile(myFilePath).ParentFolder.Path
	myFilePath = myFolderPath & myRelativePath
	If myFileSystemObject.FileExists(myFilePath) = True Then
		myFile = myFilePath
	Else
		myFile = myGetFileName(myFolderPath)
	End If
	myFindFile = myFile
End Function
Function myGetFileName(myFolder)
	Set myDialog = CreateObject("UserAccounts.CommonDialog")
	myDialog.Filter = "VBScript files|*.vbs"
	myDialog.InitialDir = myFolder
	myResult = myDialog.ShowOpen	 
	If myResult = 0 Then
	    myFileName = ""
	Else
		myFileName = myDialog.FileName
	End If
	myGetFileName = myFileName
End Function